; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back - Level Data Control Blocks
; -------------------------------------------------------------------------------------------------------------- ;
; Level Globals
; -------------------------------------------------------------------------------------------------------------- ;
; Floor Control Block
; ------------------------------------------------------------------------------------------------------------- ;
LevelFloorData        = $00 ; 
LevelFloorDataLen       = $03
LevelFloorLen         = $00 ; 
LevelFloorPosX        = $01 ; 
LevelFloorPosY        = $02 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Ladder Control Block
; -------------------------------------------------------------------------------------------------------------- ;
LevelLadderData       = $00 ; 
LevelLadderDataLen      = $03
LevelLadderPosX       = $00 ; 
LevelLadderPosYTop    = $01 ; 
LevelLadderPosYBot    = $02 ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Slide Control Block
; ------------------------------------------------------------------------------------------------------------- ;
LevelSlideData        = $00
LevelSlideDataLen       = $04
LevelSlideLength      = $00
LevelSlideMove        = $01
LevelSlideMoveDo        = $00
LevelSlideMoveDoRi      = $01
LevelSlideMoveDoLe      = $ff
LevelSlidePosX        = $02
LevelSlidePosY        = $03
; ------------------------------------------------------------------------------------------------------------- ;
; Sprite Control Block
; -------------------------------------------------------------------------------------------------------------- ;
LevelSpriteData       = $00 ; 
LevelSpriteDataLen      = $0d
LevelSpriteRaster     = $00 ; 
                      
LevelSprite1PosX      = $01 ; 
LevelSprite1PosY      = $02 ; 
LevelSprite1MinX      = $03 ; 
LevelSprite1MaxX      = $04 ; 
LevelSprite1ID        = $05 ; 
LevelSprite1DirSpeed  = $06 ; 
                      
LevelSprite2PosX      = $07 ; 
LevelSprite2PosY      = $08 ; 
LevelSprite2MinX      = $09 ; 
LevelSprite2MaxX      = $0a ; 
LevelSprite2ID        = $0b ; 
LevelSprite2DirSpeed  = $0c ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Text Control Block
; -------------------------------------------------------------------------------------------------------------- ;
TextData              = $00 ; 
TextDataLen             = $03
TextPosX              = $00 ; 
TextPosY              = $01 ; 
TextChrNo             = $02 ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Item Control Block
; ------------------------------------------------------------------------------------------------------------- ;
LevelItemData         = $00 ; 
LevelItemDataLen        = $03
LevelItemNo           = $00 ; 
LevelItemPosX         = $01 ; 
LevelItemPosY         = $02 ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Floating Platform Control Block
; ------------------------------------------------------------------------------------------------------------- ;
LevelFloatData        = $00 ; 
LevelFloatDataLen       = $05 ; 
LevelFloatPosX        = $00
LevelFloatPosY        = $01
LevelFloatMinX        = $02
LevelFloatMaxX        = $03
LevelFloatSpeed       = $04
LevelFloatMaskSpeed     = $07 ; .....###
LevelFloatMaskType      = $c0 ; ##......
LevelFloatMaskRndDir    = $10 ; ...#....
                         ; move speed - left oooo.... - oooo.### = speed
                         ; move type         ...#oooo - $10 
                         ; move type         ..#.oooo - $20 one directional
                         ; move type         .#..oooo - $40 stop wait
                         ; move type         #...oooo - $80 stop leave
                         ; move type         ##..oooo - $c0 gravity lift
; ------------------------------------------------------------------------------------------------------------- ;
; Suction Tube Control Block
; ------------------------------------------------------------------------------------------------------------- ;
LevelTube             = $00 ; 
LevelTubeLen            = $08 ; 
LevelTubeLeLen        = $00 ; left vertical tube
LevelTubeLePosX       = $01 ; 
LevelTubeLePosY       = $02 ; 
LevelTubeRiPosX       = $03 ; right vertical tube
LevelTubeRiLen        = $04 ; 
LevelTubeSwPosX       = $05 ; switch
LevelTubeSwPosY       = $06 ; 
LevelTubeSwPosYNone     = $c0 ; paint no switch if greater/equal
LevelTubeSwDir        = $07 ; 
LevelTubeSwDirOff       = $40 ; 
LevelTubeSwDirLe        = $80 ; 
LevelTubeSwDirRi        = $c0 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Level Specials
; -------------------------------------------------------------------------------------------------------------- ;
Lvl_14_LiftTopPosY    = $2a ; 
Lvl_14_LiftBotPosY    = $b2 ; 

Lvl_20_TubeMinPosX    = $20 ; right vertical tube PosX + $04
Lvl_20_TubeMaxPosX    = $95 ; 
Lvl_20_TubeMinPosY    = $12 ; left/right vertical tube len
Lvl_20_TubeMaxPosY    = $bf ; 

Lvl_22_BoxRoofPosY    = $64 ; 
Lvl_22_BoxCeilPosY    = $70 ; 
Lvl_22_BoxWallLePosY  = $00 ; 
Lvl_22_BoxWallRiPosX  = $3b ; 
Lvl_22_BoxDoorRiPosY  = $a5 ; 
Lvl_22_CannonTopPosY  = $85 ; 
Lvl_22_CannonBotPosY  = $d3 ; 
Lvl_22_TrailMinPosX   = $3e ; 
Lvl_22_TrailPosY      = $bb ; 
Lvl_22_TrailLen       = $3a ; 
Lvl_22_TxtTNTPosY     = $6c ; 
Lvl_22_ValTNTPosX     = $24 ; 
Lvl_22_ValTNTPosY     = $68 ; 
Lvl_22_TubeVertLePosX = $6d ; 
Lvl_22_TopFloorPosY   = $10 ; 
Lvl_22_MidFloorPosY   = $2f ; 
Lvl_22_LowFloorPosY   = $50 ; 
; -------------------------------------------------------------------------------------------------------------- ;
